package it.eng.eremita.servlet;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import javax.ejb.EJB;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.crygier.graphql.GraphQLSchemaBuilder;
import org.hibernate.validator.internal.util.privilegedactions.NewSchema;

import com.coxautodev.graphql.tools.SchemaParser;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import com.google.common.reflect.ClassPath.ClassInfo;

import graphql.GraphQL;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.NoOpInstrumentation;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.servlet.DefaultExecutionStrategyProvider;
import graphql.servlet.DefaultGraphQLContextBuilder;
import graphql.servlet.DefaultGraphQLErrorHandler;
import graphql.servlet.DefaultGraphQLRootObjectBuilder;
import graphql.servlet.DefaultGraphQLSchemaProvider;
import graphql.servlet.ExecutionStrategyProvider;
import graphql.servlet.GraphQLContext;
import graphql.servlet.GraphQLContextBuilder;
import graphql.servlet.GraphQLErrorHandler;
import graphql.servlet.GraphQLRootObjectBuilder;
import graphql.servlet.GraphQLSchemaProvider;
import graphql.servlet.GraphQLServletListener;
import graphql.servlet.SimpleGraphQLServlet;
import io.leangen.graphql.GraphQLSchemaGenerator;
import it.eng.eremita.graphql.Mutation;
import it.eng.eremita.graphql.Query;
import it.eng.eremita.graphql.types.SessionProvider;
import it.eng.eremita.jpa.manager.Accessor;
import it.eng.eremita.jpa.manager.EremitaManager;

@WebServlet(urlPatterns = "/graphql")
@MultipartConfig
public class GraphQLServlet extends graphql.servlet.GraphQLServlet implements SessionProvider, SingleThreadModel {
	
	//@EJB
	//EremitaManager eremitaManager;
	HttpServletRequest currentRequest = null;
	
	public GraphQLServlet() {
		
		
		super(null,null,null);
		
		executionStrategyProvider = new DefaultExecutionStrategyProvider();
	
		 if (instrumentation == null) {
	            this.instrumentation = NoOpInstrumentation.INSTANCE;
	        }

	        if(errorHandler == null) {
	            this.errorHandler = new DefaultGraphQLErrorHandler();
	        }

	        if(contextBuilder == null) {
	            this.contextBuilder = new DefaultGraphQLContextBuilder();
	        }

	        if(rootObjectBuilder == null) {
	            this.rootObjectBuilder = new DefaultGraphQLRootObjectBuilder();
	        }
	
	        
	        GraphQLServletListener listener = new GraphQLServletListener() {
	        	@Override
	        	public RequestCallback onRequest(HttpServletRequest request, HttpServletResponse response) {
	        		//System.out.println("ONREQUEST "+request.getContentLength());
	        		return null;
	        	}
	        	@Override
	        	public OperationCallback onOperation(GraphQLContext context, String operationName, String query,
	        			Map<String, Object> variables) {
	        		//System.out.println("ONOPERATION "+operationName+" QUERY "+query);
	        		return null;
	        	}
	        	
	        };
	        
	        this.addListener(listener);
	}


    private  GraphQLSchemaProvider schemaProvider = null;
    private  ExecutionStrategyProvider executionStrategyProvider = null;
    private  Instrumentation instrumentation = null;
    private  GraphQLErrorHandler errorHandler = null;
    private  GraphQLContextBuilder contextBuilder = null;
    private  GraphQLRootObjectBuilder rootObjectBuilder = null;

    @Override
    protected GraphQLSchemaProvider getSchemaProvider() {
    	//System.out.println("getSchemaProvider!");
        return schemaProvider;
    }

    @Override
    protected GraphQLContext createContext(Optional<HttpServletRequest> request, Optional<HttpServletResponse> response) {
        return this.contextBuilder.build(request, response);
    }

    @Override
    protected Object createRootObject(Optional<HttpServletRequest> request, Optional<HttpServletResponse> response) {
        return this.rootObjectBuilder.build(request, response);
    }

    @Override
    protected ExecutionStrategyProvider getExecutionStrategyProvider() {
        return executionStrategyProvider;
    }

    @Override
    protected Instrumentation getInstrumentation() {
        return instrumentation;
    }

    @Override
    protected Map<String, Object> transformVariables(GraphQLSchema schema, String query, Map<String, Object> variables) {
        return variables;
    }

    @Override
    protected GraphQLErrorHandler getGraphQLErrorHandler() {
        return errorHandler;
    }
    
    @Override
    public void init() {
    	
    	
    	it.eng.eremita.graphql.types.Query query = new it.eng.eremita.graphql.types.Query(this);
    	it.eng.eremita.graphql.types.Mutation mutation = new it.eng.eremita.graphql.types.Mutation(this);

    	GraphQLSchema schema = new GraphQLSchemaGenerator()
    			.withDefaults()
    		    .withOperationsFromSingletons(query,mutation) //register the service
    		    .generate(); //done ;)
    	
    	
    	//GraphQLSchema schema = Accessor.getEremitaManager().getGraphQLSchema(this);
    	
    	schemaProvider = new DefaultGraphQLSchemaProvider(schema);
    	
    	
    	try {
    	super.init();
    	} catch (Exception e) { e.printStackTrace();}
        
    }
   
    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    	// TODO Auto-generated method stub
    	try {
    		System.out.println("doPost");
    		currentRequest = req;
    		

    	super.doPost(req, resp);
    	
    	System.out.println("status "+resp.getStatus());
    	} catch (Exception e) {
    		throw e;
    	}
    }
    
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    	// TODO Auto-generated method stub
    	try {
    		System.out.println("doGet");
    		
    		currentRequest = req;

    		if (req.getParameter("query")==null) super.doPost(req, resp);
    		else super.doGet(req, resp);
    	System.out.println("status "+resp.getStatus());
    	} catch (Exception e) {
    		throw e;
    	}
    }

	@Override
	public HttpServletRequest getRequest() {
		// TODO Auto-generated method stub
		return currentRequest;
	}

    
}
